/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import oracle.cluster.cmdtools.ASMCMDUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.KFODUtil;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskASMMissizedDiskCheck
extends Task {
    private final String EXE_LOC = "bin";
    private boolean m_isSIHA = false;
    private final String ASMCMD_DSGET_CMD = "asmcmd dsget --normal";
    final String ASMCMD_ERR_STR = "ASMCMD-";
    private final String ASMCMD_OUTPUT_PARAM = "parameter:";
    private String m_version = null;

    public TaskASMMissizedDiskCheck(String[] nodeList) {
        super(nodeList);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Checking ASM disk size consistency...");
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11633", false));
        String crsHome = null;
        crsHome = !this.m_isSIHA ? VerificationUtil.getCRSHome() : VerificationUtil.getHAHome();
        if (crsHome == null) {
            Trace.out((String)"crshome is null");
            String errMsg = null;
            errMsg = !this.m_isSIHA ? s_msgBundle.getMessage("5301", true) : s_msgBundle.getMessage("5307", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        Trace.out((String)("crsHome = '" + crsHome + "'"));
        String version = null;
        version = !this.m_isSIHA ? VerificationUtil.getCRSActiveVersion() : VerificationUtil.getSIHAReleaseVersion(true);
        if (version != null) {
            Trace.out((String)("crs version = " + version));
        } else {
            Trace.out((String)"crs version couldn't be determined");
            ErrorDescription errDesc = null;
            errDesc = !this.m_isSIHA ? new ErrorDescription("5300", s_msgBundle) : new ErrorDescription("5325", s_msgBundle);
            ReportUtil.sureprintln(errDesc.getErrorMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
        }
        String kfodLocation = null;
        String kfodBinary = "kfod";
        KFODUtil kf = null;
        try {
            String homeLocation;
            kfodLocation = !VerificationUtil.isVersionPre(version, "12.1") ? VerificationUtil.getKFODLocation(m_localHost, true) : (!VerificationUtil.isBinaryExistsInsideHome(homeLocation = VerificationUtil.getCVHome(), kfodBinary) ? homeLocation + ".." + FSEP + "ext" + FSEP + "bin" : homeLocation + "bin");
            Trace.out((String)("running kfod from " + kfodLocation));
            kf = new KFODUtil(kfodLocation);
        }
        catch (CmdToolUtilException e) {
            Trace.out((String)("exception while trying to get Missized ASM disks " + e.getMessage()));
            VerificationLogData.logError(e.getMessage());
            String errMsg = e.getMessage();
            ReportUtil.printError(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((String)("exception while trying to get Missized ASM disks " + e.getMessage()));
            VerificationLogData.logError(e.getMessage());
            String errMsg = e.getMessage();
            ReportUtil.printError(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        String discoveryString = null;
        if (VerificationUtil.isVersionPre(version, "11.2")) {
            try {
                Hashtable<String, Boolean> discoveryStringHT = VerificationUtil.getASMDiscoveryString();
                for (Map.Entry<String, Boolean> entry : discoveryStringHT.entrySet()) {
                    discoveryString = entry.getKey();
                }
            }
            catch (CVUException e) {
                Trace.out((String)("exception while trying to get asm discovery string" + e.getMessage()));
                VerificationLogData.logError(e.getMessage());
                String errMsg = e.getMessage();
                ReportUtil.printError(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                return false;
            }
        }
        try {
            Result result = new Result(m_localHost);
            String crshome = VerificationUtil.getCRSHome(m_localHost, result);
            if (!VerificationUtil.isStringGood(crshome)) {
                Trace.out((String)"Failed to get CRS HOME");
                String msg = s_msgBundle.getMessage("5301", true);
                ReportUtil.sureprintln(msg);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(m_localHost, result);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return false;
            }
            ASMCMDUtil acu = new ASMCMDUtil(crshome);
            List discoveryStringList = acu.getAllDiscoveryStrings();
            if (discoveryStringList == null || discoveryStringList.size() == 0) {
                Trace.out((String)"discovery string list is empty");
                VerificationLogData.logError("empty discovery string list");
                String msg = s_msgBundle.getMessage("5713", true, (Object[])new String[]{"asmcmd dsget --normal", m_localHost});
                ReportUtil.sureprintln(msg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                return false;
            }
            if (discoveryStringList.size() > 2 && ((String)discoveryStringList.get(0)).startsWith("ASMCMD-")) {
                Trace.out((String)"discovery string list conatins errors");
                String discErrList = VerificationUtil.strList2List(discoveryStringList, LSEP);
                VerificationLogData.logError("discovery String list contains errors " + discErrList);
                String msg = s_gMsgBundle.getMessage("4655", true, (Object[])new String[]{"asmcmd dsget --normal"}) + LSEP + discErrList;
                ReportUtil.sureprintln(msg);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                return false;
            }
            if (discoveryStringList.size() > 2) {
                Trace.out((String)("discoveryString list size is larger than expected " + discoveryStringList.size()));
                VerificationLogData.logError("discoveryString list size is larger than expected " + discoveryStringList.size());
                for (String line : discoveryStringList) {
                    VerificationLogData.logError(line);
                }
                String msg = s_msgBundle.getMessage("5714", true, (Object[])new String[]{"asmcmd dsget --normal", VerificationUtil.strList2List(discoveryStringList, LSEP)});
                ReportUtil.sureprintln(msg);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                return false;
            }
            String ds = (String)discoveryStringList.get(0);
            if (ds.startsWith("parameter:")) {
                discoveryString = ds.substring("parameter:".length(), ds.indexOf(",") != -1 ? ds.indexOf(",") : ds.length());
            }
        }
        catch (CmdToolUtilException e) {
            Trace.out((String)("exception while trying to get discovery string using asmcmd :" + e.getMessage()));
            VerificationLogData.logError(e.getMessage());
            String errMsg = e.getMessage();
            ReportUtil.printError(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        if (!VerificationUtil.isStringGood(discoveryString)) {
            Trace.out((String)"Discovery string from asmcmd command found to be empty. Using Default Discovery string");
            String[] discoveryStringArray = VerificationUtil.getDefaultDiscoveryDevice(version);
            if (discoveryStringArray.length > 0) {
                discoveryString = Arrays.asList(discoveryStringArray).toString();
            }
            if (!VerificationUtil.isStringGood(discoveryString)) {
                Trace.out((String)"Failed to retrive default discovery string");
                VerificationLogData.logError("default discovery string is null or empty");
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return false;
            }
        }
        try {
            List asmMissizedDiskList = kf.getMissizedASMDiskList(m_localHost, discoveryString);
            if (asmMissizedDiskList.size() == 0) {
                Trace.out((String)"All ASM disks have correct header information and matching with the actual disk size");
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("11634", false));
                this.m_resultSet.addResult(this.m_nodeList, 1);
                return true;
            }
            String missizedDisks = VerificationUtil.strList2List(asmMissizedDiskList, ",");
            Trace.out((String)("The following ASM disks are having wrong disk header information:" + LSEP + missizedDisks));
            VerificationLogData.logError("The following  ASM disks are  having wrong disk header information:" + LSEP + missizedDisks);
            String msg = s_gMsgBundle.getMessage("11635", true, (Object[])new String[]{missizedDisks});
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        catch (CmdToolUtilException e) {
            Trace.out((String)("exception while trying to check if there are any mis-sized asm disks: " + e.getMessage()));
            VerificationLogData.logError(e.getMessage());
            String errMsg = e.getMessage();
            ReportUtil.printError(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
    }

    void setSIHAMode() {
        this.m_isSIHA = true;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11631", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11632", false);
    }
}

